# File : "mfMenus.tcl"
#                        Created : 2001-02-06 22:07:36
#              Last modification : 2001-02-13 23:57:30
# Author : Bernard Desgraupes
# e-mail : <berdesg@easynet.fr>
# www : <http://perso.easynet.fr/~berdesg/>
# Description : this file is part of the Metafont Mode package for 
# Alpha. See comments at the beginning of 'mfMode.tcl'.
# 

proc mfMenus.tcl {} {}

# This is to load the main file mfMode.tcl first
mfMenu


namespace eval Mf {}


# Metafont Menus declarations
# ===========================

menu::buildProc mfMenu Mf::buildMfMenu
menu::buildProc otherFiles Mf::buildotherFilesMenu
menu::buildProc convertFiles Mf::buildConvertFilesMenu
menu::buildProc removeFiles Mf::buildremoveFilesMenu
menu::buildProc sourceFiles Mf::buildsourceFilesMenu

ensureset mf_params(mflongmenu) 0


# Menu building procs
# -------------------

proc Mf::buildMfMenu {} {
	global mfMenu mf_params
	set ma {
	"switchToMetafont"
	"(-"
	"/R<UrunTheBuffer"
	"saveAndRun"
	"<E<SrunAFile"
	"<S<IrunAFolder"
	"<S<BrunCurrentFolder"
	"(-"
{Menu -n "metafontMode" -p Mf::choosemodeProc {
	"proof"
	"smoke"
	"localfont"
	"userDefined"
	}
}
{Menu -n "processingOptions" -p Mf::processingoptProc {
	"mag..."
	"magstep..."
	"baseFile..."
	"(-"
	"gfcorners"
	"imagerules"
	"nodisplays"
	"notransforms"
	"screenchars"
	"screenstrokes"
	"(-"
	"clearAllOptions"
	}
}
	"(-"
}
	lappend ma [list Menu -n sourceFiles {}]
	lappend ma [list Menu -n convertFiles {}]
	lappend ma [list Menu -n otherFiles {}]
	append ma {
	  "(-"
	  "newFontTemplate"
	  }
	  if {!$mf_params(mflongmenu)} {
	      append ma "makeLongMenu"
	      } else {
	  append ma {
	  "makeShortMenu"
	  "(-"
{Menu -n "variables" -p Mf::variablesProc {	
	" boolean"
	" numeric"
	" pair"
	" path"
	" pen"
	" picture"
	" string"
	" transform"
	" newinternal"
	}
}
{Menu -n "boolean" -p Mf::booleanProc {	
	" charexists"
	" cycle"
	" false"
	" known"
	" true"
	" unknown"
	}
}
{Menu -n "functions" -p Mf::functionsProc {	
	" angle"
	" ceilling"
	" floor"
	" cosd"
	" sind"
	" mexp"
	" mlog"
	" sqrt"
	"(-"
	" round"
	" hround"
	" vround"
	" dotprod"
	"(-"
	" eps"
	" epsilon"
	" infinity"
	"(-"
	" solve"
	" tolerance"
	"(-"
	" normaldeviate"
	" randomseed"
	" uniformdeviate"
	" whatever"
	}
}
{Menu -n "positioning" -p Mf::positioningProc {	
	" direction"
	" directionpoint"
	" directiontime"
	" penoffset"
	" pointof"
	" precontrolof"
	" postcontrolof"
	" intersectionpoint"
	" intersectiontimes"
	"(-"
	" good.bot"
	" good.lft"
	" good.rt"
	" good.top"
	" good.x"
	" good.y"
	"(-"
	" xpart"
	" xxpart"
	" xypart"
	" ypart"
	" yxpart"
	" yypart"
	" clearxy"
	}
}
{Menu -n "paths" -p Mf::pathsProc {	
	" penstroke"
	" buildpenstroke"
	"(-"
	" flex"
	" fullcircle"
	" halfcircle"
	" quartercircle"
	" superellipse"
	" unitsquare"
	"(-"
	" makepath"
	" interpath"
	" subpath"
	" tensepath"
	" counterclockwise"
	" reverse"
	"(-"
	" turningnumber"
	}
}
{Menu -n "pens" -p Mf::pensProc {	
	" <E<Spencircle"
	" <S<Opickuppencircle"
	" <S<Ipencirclescaled"
	" <S<I<Opickuppencirclescaled"
	" <E<Spensquare"
	" <S<Opickuppensquare"
	" <S<Ipensquarescaled"
	" <S<I<Opickuppensquarescaled"
	" penrazor"
	" penspeck"
	"(-"
	" penpos"
	"(-"
	" clear_pen_memory"
	" clearpen"
	" currentpen"
	" makepen"
	" nullpen"
	" savepen"
	"(-"
	" pen_bot"
	" pen_lft"
	" pen_rt"
	" pen_top"
	" pickup"
	}
}
{Menu -n "pictures" -p Mf::picturesProc {	
	" blankpicture"
	" clearit"
	" currentpicture"
	" nullpicture"
	"(-"
	" totalweight"
	" unitpixel"
	}
}
{Menu -n "transformations" -p Mf::transformationsProc {	
	" currenttransform"
	" identity"
	" inverse"
	" reflectedabout"
	" rotated"
	" rotatedaround"
	" scaled"
	" shifted"
	" slanted"
	" transformed"
	" xscaled"
	" yscaled"
	" zscaled"
	}
}
{Menu -n "definitions" -p Mf::definitionsProc {	
	" defenddef"
	" suffix"
	" expr"
	" text"
	" primarydefenddef"
	" secondarydefenddef"
	" tertiarydefenddef"
	" vardefenddef"
	" begingroupendgroup"
	}
}
{Menu -n "conditions" -p Mf::conditionsProc {	
	" forendfor"
	" foreverendfor"
	" forsuffixesendfor"
	" iffi"
	" ifelseifelsefi"
	" downto"
	" upto"
	" stepuntil"
	" exitif"
	" exitunless"
	}
}
{Menu -n "drawing" -p Mf::drawingProc {	
	" <Saddtoalso"
	" <S<Iaddtocurrentpicture"
	" <E<Saddtocontour"
	" <S<Iaddtocontourwithpen"
	" <S<Oaddtocontourwithweight"
	" <E<Saddtodoublepath"
	" <S<Iaddtodoublepathwithpen"
	" <S<Oaddtodoublepathwithweight"
	" <E<Sculldropping"
	" <S<Oculldroppingwithweight"
	" <E<Scullkeeping"
	" <S<Ocullkeepingwithweight"
	" cullit"
	"(-"
	" <E<Sdraw"
	" <S<Iundraw"
	" <E<Sdrawdot"
	" <S<Iundrawdot"
	" <E<Sfill"
	" <S<Iunfill"
	" <E<Sfilldraw"
	" <S<Iunfilldraw"
	"(-"
	" cutdraw"
	" cutoff"
	" erase"
	}
}
{Menu -n "characters" -p Mf::charactersProc {	
	" begincharendchar"
	" extra_beginchar"
	" extra_endchar"
	}
}
{Menu -n "modesDefinitions" -p Mf::unitsProc {	
	" blacker"
	" fillin"
	" o_correction"
	" fix_units"
	" mode_setup"
	" pixels_per_inchs"
	" aspect_ratio"
	}
}
{Menu -n "pixellisation" -p Mf::pixellisationProc {	
	" define_pixels"
	" define_blacker_pixels"
	" define_good_x_pixels"
	" define_good_y_pixels"
	" define_corrected_pixels"
	" define_horizontal_corrected_pixels"
	" define_whole_pixels"
	" define_whole_blacker_pixels"
	" define_whole_vertical_pixels"
	" define_whole_vertical_blacker_pixels"
	}
}
{Menu -n "fontInternals" -p Mf::fontInternalsProc {	
	" charlist"
	" extensible"
	" font_coding_scheme"
	" font_extra_space"
	" font_identifier"
	" font_normal_shrink"
	" font_normal_space"
	" font_normal_stretch"
	" font_quad"
	" font_size"
	" font_slant"
	" font_x_height"
	" fontdimen"
	" headerbytes"
	" ligtable"
	" kern"
	}
}
{Menu -n "strings" -p Mf::stringsProc {	
	" ditto"
	" jobname"
	" readstring"
	" substring"
	}
}
{Menu -n "displaying" -p Mf::displayingProc {	
	" currentwindow"
	" displayinwindow"
	" openwindowfromtoat"
	" screen_cols"
	" screen_rows"
	" screenrule"
	}
}
{Menu -n "output" -p Mf::outputProc {	
	" openit"
	" shipit"
	" showit"
	"(-"
	" labels"
	" labelsrangethru"
	" penlabels"
	" makelabel"
	" makegrid..."
	"(-"
	" proofoffset"
	" proofrule"
	" proofrulethickness"
	"(-"
	" grayfont"
	" labelfont"
	" slantfont"
	" titlefont"
	}
}
{Menu -n "debugging" -p Mf::debuggingProc {	
	" errhelp"
	" errmessage"
	" message"
	" stop"
	"(-"
	" show"
	" showdependencies"
	" showstats"
	" showtoken"
	" showvariable"
	"(-"
	" loggingall"
	" tracingall"
	" tracingnone"
	"(-"
	" batchmode"
	" errorstopmode"
	" nonstopmode"
	" scrollmode"
	}
}
{Menu -n "misc" -p Mf::miscProc {	
	" capsule_def"
	" expandafter"
	" gobble"
	" gobbled"
	" interact"
	" numtok"
	" scantokens"
	" special"
	" numspecial"
	}
}
{Menu -n "internalVariables" -p Mf::varintProc {	
	" autorounding"
	" designsize"
	" fontmaking"
	" granularity"
	" pausing"
	" proofing"
	" showstopping"
	" smoothing"
	"(-"
	" charcode"
	" chardp"
	" chardx"
	" chardy"
	" charext"
	" charht"
	" charic"
	" charwd"
	"(-"
	" hppp"
	" vppp"
	"(-"
	" xoffset"
	" yoffset"
	"(-"
	" day"
	" month"
	" year"
	" time"
	"(-"
	" tracingcapsules"
	" tracingchoices"
	" tracingcommands"
	" tracingedges"
	" tracingequations"
	" tracingmacros"
	" tracingonline"
	" tracingoutput"
	" tracingpens"
	" tracingrestores"
	" tracingspecs"
	" tracingstats"
	" tracingtitles"
	" turningcheck"
	" warningcheck"
	}
}
}
}
	return [list build $ma Mf::menuProc {convertFiles sourceFiles otherFiles} $mfMenu]
}

proc Mf::buildConvertFilesMenu {} {
    global mf_params MfmodeVars 
    set mf_params(basefilename) [file rootname [file tail [win::Current]]]
    set ma "$mf_params(prefixgf)convertGfToPk"
    if {$MfmodeVars(mfAppSig) == "CMT3"} {
	lappend ma "<E$mf_params(prefixgf)convertGfToDvi"
    }
    lappend ma "<E$mf_params(prefixdvi)view $mf_params(basefilename).dvi"
    if {$MfmodeVars(mfAppSig) == "CMT3"} {
	lappend ma "<E$mf_params(prefixdvi)convert $mf_params(basefilename).dvi to ps"
    }
    lappend ma "<E<S$mf_params(prefixtfm)convert $mf_params(basefilename).tfm to pl"
    lappend ma  "(-"
    lappend ma "tfmToPl..."
    lappend ma "vfToVpl..."
    lappend ma  "(-"
    lappend ma "plToTfm..."
    lappend ma "vplToVf..."
    return [list build $ma Mf::convertFilesProc {removeFiles} ]
}

proc Mf::buildotherFilesMenu {} {
    global mf_params MfmodeVars 
    
    set mf_params(basefilename) [file rootname [file tail [win::Current]]]
    set ma ""
    lappend ma "$mf_params(prefixlog)open $mf_params(basefilename).log"
    lappend ma "$mf_params(prefixpl)open $mf_params(basefilename).pl" 
    foreach i {"(-" "open modes.mf" "open plain.mf" "(-" "metafontBindings"} {
	lappend ma $i
    }
    lappend ma "selectAFolder..."
    lappend ma [list Menu -n removeFiles {}]
    lappend ma  "(-"
    if {$mf_params(currentdir) != ""} {
	lappend ma  [menu::itemWithIcon "currentFolderIs:" 83] 
	lappend ma " [file tail $mf_params(currentdir)]"
    } else {
	lappend ma [menu::itemWithIcon "noFolderSelected" 82] 
    }
    return [list build $ma Mf::otherfilesProc {removeFiles} ]
}

proc Mf::buildremoveFilesMenu {} {
    global mf_params
    set ma "$mf_params(prefixrmall)allLogFiles"
    lappend ma "$mf_params(prefixrmall)allGfFiles"
    lappend ma "$mf_params(prefixrmall)allPkFiles"
    lappend ma "$mf_params(prefixrmall)allDviFiles"
    lappend ma "$mf_params(prefixrmall)allTfmFiles"
    lappend ma "$mf_params(prefixrmall)allVfFiles"
    lappend ma "$mf_params(prefixrmall)allPlFiles"
    lappend ma "$mf_params(prefixrmall)allVplFiles"
    lappend ma "(-"
    lappend ma "$mf_params(prefixrmall)allOfThem"
    
    return [list build $ma Mf::removefilesProc ]
}	

# ---------------------------------------------------------------
# List source files
# ---------------------------------------------------------------
proc Mf::listSrcInDir {dir ext} {
    global mf_params
    set itemslist($dir) [glob -nocomplain -dir $dir *]
    foreach f $itemslist($dir) {
	if {[file isfile $f] && [file extension [file tail $f]]==".mf"} {
	    set f [file tail $f]
	    regsub "\(\[^\\.\]\)\.mf" $f "\\1" f
	    lappend mf_params(filenames) " $f"
	} elseif {[file isdirectory $f]} {
	    Mf::listSrcInDir $f mf
	}
    }
}

proc Mf::buildsourceFilesMenu {} {
    global mf_params MfmodeVars mfPathsArray
    set defaultSubmenuItems "Menu -m -n sourceFiles -p Mf::sourceFilesProc \{{Rebuild Source List} {(-}\}"
    if {$MfmodeVars(buildSourceFiles)} {
	if {$MfmodeVars(pathToSourceFolder) == ""} {
	    catch {get_directory -p "Locate a folder."} mfdir
	    if {$mfdir != ""} {
		set MfmodeVars(pathToSourceFolder) $mfdir
		prefs::modified MfmodeVars(pathToSourceFolder)
	    } else {
		set mf_params(filenames) {}
		return $defaultSubmenuItems
	    }	    
	}	
	if { ![info exists mf_params(mfSubmenuItems)] || $mf_params(mfSubmenuItems) == "" } {
	    set mf_params(reste) ""
	    set mf_params(mfSubmenuItems) \
	      [menu::buildHierarchy [list "$MfmodeVars(pathToSourceFolder)"] "sourceFiles" \
	      Mf::sourceFilesProc mfPathsArray ".mf" $MfmodeVars(nestingDepth)]
	    regexp {^Menu -m -n sourceFiles -p Mf::sourceFilesProc \{(.*)$} $mf_params(mfSubmenuItems) "" mf_params(reste)
	    regsub -all "(Menu -m -n\[ \]+(\{)?)" $mf_params(reste) "\\1$mf_params(mfsymb)" mf_params(reste)
	    if {$mf_params(reste)!=""} {
		set mf_params(mfSubmenuItems) "Menu -m -n sourceFiles -p Mf::sourceFilesProc \{{Rebuild Source List} {(-} $mf_params(reste)"
	    } else {
		set mf_params(mfSubmenuItems) $defaultSubmenuItems
	    }
	} 
    } else {
	set mf_params(mfSubmenuItems) $defaultSubmenuItems
    }
    if {$MfmodeVars(pathToSourceFolder) != ""} {
	Mf::listSrcInDir "$MfmodeVars(pathToSourceFolder)" mf
    }
    return $mf_params(mfSubmenuItems)
}

# ---------------------------------------------------------------
# Proc to toggle between long and short menus
# ---------------------------------------------------------------
proc Mf::makeLongMenu {len} {
    global mf_params mfMenu modifiedVars
    set mf_params(mflongmenu) $len
    lappend modifiedVars mf_params(mflongmenu)
    menu::buildSome mfMenu 
    markMenuItem metafontMode $mf_params(chosenMode) 1
    Mf::markOptionsMenu
}

# ---------------------------------------------------------------
# Effective building of Metafont menu
# ---------------------------------------------------------------

menu::buildSome mfMenu 

markMenuItem metafontMode proof 1
